import requests
import pandas
import webbrowser
import urllib.parse

response = requests.get(
    url="https://www.freetogame.com/api/games",
    params={
        'platform': 'pc',
        'category': 'strategy',
        'sort-by': 'relevance'
    }
)

if response.status_code == 200:
    gegevens = response.json()

    gegevensframe = pandas.DataFrame(gegevens)

    genre_tellingen = gegevensframe['genre'].value_counts()

    tellingen_als_strings = []
    for telling in genre_tellingen:
        tellingen_als_strings.append(str(telling))

    gegevens_reeks = ",".join(tellingen_als_strings)

    labels = []
    for genre in genre_tellingen.index:
        labels.append(urllib.parse.quote_plus(str(genre)))
    labels_reeks = "|".join(labels)

    grafiek_type = "bvs"
    grootte = "600x400"

    api_url = f"https://image-charts.com/chart?cht={grafiek_type}&chd=a:{gegevens_reeks}&chs={grootte}&chl={labels_reeks}"

    webbrowser.open(api_url)
else:
    print(f"Fout: {response.status_code} - {response.text}")
